#ifndef CORRELATOR_H_
#define CORRELATOR_H_
#include <iostream>
#include <memory>
#include <array>
#include <vector>
#include "propagator.h"
#include "Gamma.h"
// corr Base virtual stcture for the correlators. It should never be used directly.
// Always refer to corr_npt<N>
struct corr{
  virtual void print(std::ostream&)=0;
  virtual size_t npoint() const  = 0;
  virtual int get_propagator_id(int i) const =0;
  virtual ~corr()= default;
#if __cplusplus>=201402L
  virtual std::unique_ptr<corr> make_unique_ptr() = 0;
#endif
};

template <size_t N>
struct corr_npt :  corr {
  std::array<int,N> propagator_id;
  std::array<Gamma,N> gamma;
  std::array<double,N> kappa;
  std::array<double,N> mus;
  std::array<int,N-1> xn;// position of the N points.
  std::array<std::array<double,3>,N> theta;
  std::array<bool,N> is_seq;
  std::array<int,N> seq_id;
  ~corr_npt() override = default;

  corr_npt(std::array<int,N> prop, std::array<Gamma,N> g, std::array<double, N> kappa, std::array<double,N> mu, std::array<int, N-1> xn,std::array<std::array<double,3>,N> theta,std::array<bool,N> is_seq, std::array<int,N> seq_id) :
    propagator_id(prop),gamma(g),kappa(kappa),mus(mu),xn(xn),theta(theta),is_seq(is_seq),seq_id(seq_id){};

  corr_npt(const corr_npt<N> &corrs) = default;

  size_t npoint() const override {return N;};

  int get_propagator_id(int i) const override {return propagator_id[i];};

  void print(std::ostream& os) override;
  #if __cplusplus>=201402L
  std::unique_ptr<corr> make_unique_ptr() override;
  #endif
};

void read_all_corr(std::ifstream &file, std::vector<std::unique_ptr<corr>> & corrs, std::vector<propagator> &prop, int ncorr);

bool compare_corr(const corr&A, const corr&B);



#if __cplusplus>=201402L
bool compare_corr(const std::unique_ptr<corr> &A, const std::unique_ptr<corr> &B);
void condense_correlator(std::vector<std::unique_ptr<corr>> &corrs);
#else
corr *compare_corr(const corr* A, corr* B);
void condense_correlators(std::vector<corr*> &corrs);
#endif

#endif // CORRELATOR_H_
