#ifndef PROPAGATOR_H
#define PROPAGATOR_H
#include <vector>
#include <array>
#include <iostream>

#include "Gamma.h"

struct propagator{
  double kappa;
  double mu;
  std::array<double,3> theta;
  bool seq_prop=false;
  int seq_id=-1;
  int src{-1};
  Gamma seq_type;

  friend std::ostream& operator<<(std::ostream& os, const propagator &prop);
};

void read_all_propagator(std::ifstream &file, std::vector<propagator>& props, int nprop);

#endif // PROPAGATOR_H
