#include <fstream>
#include <string>
#include <regex>
#include <iostream>
#include "../include/file_manip.h"

// parse the file until "section name" is found. file is left at the beginning of the section, that is right after the section name.
// section_name should not contain square brakets "[]"!!
//
// It assume that "section_name" is after the current position in the input stream.
// If you might have pass it, it is better to reset the input stream position to the beginning and then call find_section
void find_section(std::ifstream &file, const std::string& section_name){
  std::string line;
  while(!file.eof()){
    std::getline(file, line);
    if (line.find(section_name) !=std::string::npos) return;
  }

  std::cerr << "[find_section]: Section " << section_name << " not found!"<< std::endl;
  exit(1);
}

void read_measurements(std::ifstream &file, std::vector<int> &par){
  find_section(file,"Measurements");
  std::string line;
  std::regex rgx_int("[0-9]+");
  read_line(file, line);
  check_line(line, "nprop");
  par[0] = std::stoi(get_match(line,rgx_int));

  read_line(file, line);
  check_line(line, "ncorr");
  par[1] = std::stoi(get_match(line,rgx_int));

}


// read lines untill a non-comment line is found. a comment line is recognised if the first non-space character is '#'
void inline read_line(std::ifstream &file, std::string &line){
int i=0;
  while(true){
    std::getline(file,line);
    while(std::isspace(line[i])){
      i++;
    }
    if(line[i] !='#') return;
  }
}

inline void check_line(const std::string& line,const  std::string &name){
  if(line[0]=='['|| line.empty()){
    std::cerr << "[check_line] inputstream position is not where expected. make sure to call find_section() first. " << std::endl;
    exit(1);
  }
  if(line.find(name)==std::string::npos){
    std::cerr << "[check_line] " << name<< " field expected. Found " << line << std::endl;
    exit(1);
  }
}

inline std::string get_match(const std::string& line, const std::regex &rgx){
  static std::smatch match;
  if(!std::regex_search(line,match,rgx)){
    std::cerr << "[get_match] No match in "<< line <<  std::endl;
    exit(1);
  }
  return match.str(0);
}

std::vector<std::string> get_all_match(const std::string& line, const std::regex& rgx){
  static std::smatch match;
  if(!std::regex_search(line,match,rgx)){
     std::cerr << "[get_all_match] No match in "<< line <<  std::endl;
     exit(1);
  }

  std::vector<std::string> res{match.str(0)};
  std::string aux = match.suffix();
  while(std::regex_search(aux,match,rgx)){
    res.push_back(match.str(0));
    aux = match.suffix();
  }

  return res;
}
