#ifndef GAMMA_H_
#define GAMMA_H_
#include <string>

enum Gamma{
  gamma0,  gamma1,  gamma2,  gamma3,id, gamma5=5,
  gamma01, gamma02,  gamma03,gamma05=10,
  gamma12=12, gamma13, gamma15=15,
  gamma23=23, gamma25=25,
  gamma35=35,
};

// Takes a string 'g' and return the associated Gamma::gamma_matrix element
inline Gamma stog(std::string g){
 // std::cout << g << std::endl;
  if(g.length()==0){
    std::cerr<< "[stog] Empty string" << std::endl;
    exit(0);
  }

  if(g.length() ==1){
    if(g!="1"){
      std::cerr << "[stog] invalid gamma structure " << g << std::endl;
      exit(1);
    }
    return Gamma::id;
  }

  if(g.length()==2) return static_cast<Gamma>(g[1]-'0');

  if ( g.length()==3 || g.length()>=5){
    std::cerr << "[stog] invalid gamma structure " << g << std::endl;
    exit(1);
  }

  int a = g[1]-'0';
  int b = g[3]-'0';

  if (a==0) return static_cast<Gamma>(5+ b);

  return static_cast<Gamma>(a*10+b);
}

// Takes a Gamma::gamma_matrix and return the associated std::string
inline std::string gtos(Gamma g){
  switch(g){
  case gamma0: return "G0";
  case gamma1: return "G1";
  case gamma2: return "G2";
  case gamma3: return "G3";
  case id: return "1";
  case gamma5: return "G5";
  case gamma01: return "G0G1";
  case gamma02: return "G0G2";
  case gamma03: return "G0G3";
  case gamma05: return "G0G5";
  case gamma12: return "G1G2";
  case gamma13: return "G1G3";
  case gamma15: return "G1G5";
  case gamma23: return "G2G3";
  case gamma25: return "G2G5";
  case gamma35: return "G3G5";
  default:
    std::cerr << "[gtos] gamma structure " << g<<" not defined"<< std::endl;
    exit(1);
  }
}


#endif // GAMMA_H_
