#ifndef FILE_MANIP_H_
#define FILE_MANIP_H_
#include <fstream>
#include <string>
#include <regex>
#include <vector>

void find_section(std::ifstream &file, const std::string &section_name);
void read_line(std::ifstream &file, std::string &line);
void check_line(const std::string &line, const std::string &name);
std::string get_match(const std::string &line, const std::regex &rgx);
std::vector<std::string> get_all_match(const std::string &line, const std::regex &rgx);

void read_measurements(std::ifstream &file, std::vector<int> &par);


#endif // FILE_MANIP_H_
