#include <iostream>
#include "../include/Gamma.h"
#include "../include/file_manip.h"
#include "../include/propagator.h"
std::ostream& operator<<(std::ostream& os, const propagator &prop){
    os << "kappa : " << prop.kappa << std::endl;
    os << "mu    : " << prop.mu    << std::endl;
    os << "theta : ";
    for(auto t : prop.theta)
      os << t << "  ";
    os << std::endl;
    if(prop.seq_prop){
      os << "sequential propagator: " << std::endl;
      os << "seq_id: " << prop.seq_id << std::endl;
      os << "Gamma:  " << prop.seq_type << std::endl;
      os << "source: " << prop.src << std::endl;
     }
    return os;
  }
void read_all_propagator(std::ifstream &file, std::vector<propagator>& props, int nprop){
  props.clear();
  props.resize(nprop);

  std::string temp;
  std::vector<std::string> vtemp;
  std::regex rgx_double("\\s[+-]?([0-9]*[.])?[0-9]+");
  std::regex rgx_int("\\s[+-]?[0-9]+");
  std::regex rgx_double_int("\\s[+-]?[0-9]*([.]*[0-9]+)");
  std::regex rgx_gamma("(G[0-5]){1,2}");

  for(int i=0; i<nprop; i++){
    find_section(file, "Propagator "+std::to_string(i));
    read_line(file,temp);
    check_line(temp,"kappa");
    props[i].kappa = std::stod(get_match(temp,rgx_double));

    read_line(file,temp);
    check_line(temp,"mus");
    props[i].mu = std::stod(get_match(temp,rgx_double));

    read_line(file,temp);
    check_line(temp,"theta");
    vtemp = get_all_match(temp,rgx_double_int);
    for(unsigned j=0; j<3; j++){
      //std::cout<< "ok"<< std::endl;
      props[i].theta[j] = std::stod(vtemp[j]);
    }

    read_line(file,temp);
    if(temp.empty()) return;
    if(temp[0]=='['){
      std::cerr << "[read_propagator] inputstream position moved too far." << std::endl;
      exit(1);
    }

    if (temp.find("seq_prop")!= std::string::npos){
      props[i].seq_prop=true;
      props[i].seq_id=std::stoi(get_match(temp,rgx_int));

      read_line(file,temp);
      check_line(temp,"seq_type");
      props[i].seq_type = stog(get_match(temp,rgx_gamma));

      read_line(file,temp);
      check_line(temp,"seq_x0");
      props[i].src = std::stoi(get_match(temp,rgx_int));
    }
  }
}
