var documenterSearchIndex = {"docs":
[{"location":"reader.html#Reader","page":"Reader","title":"Reader","text":"","category":"section"},{"location":"reader.html","page":"Reader","title":"Reader","text":"read_mesons\nread_ms\nread_ms1\nread_md\ntruncate_data!","category":"page"},{"location":"reader.html#juobs.read_mesons","page":"Reader","title":"juobs.read_mesons","text":"read_mesons(path::String, g1::Union{String, Nothing}=nothing, g2::Union{String, Nothing}=nothing; id::Union{String, Nothing}=nothing, legacy::Bool=false)\n\nread_mesons(path::Vector{String}, g1::Union{String, Nothing}=nothing, g2::Union{String, Nothing}=nothing; id::Union{String, Nothing}=nothing, legacy::Bool=false)\n\nThis function read a mesons dat file at a given path and returns a vector of CData structures for different masses and Dirac structures. Dirac structures g1 and/or g2 can be passed as string arguments in order to filter correaltors. ADerrors id can be specified as argument. If is not specified, the id is fixed according to the ensemble name (example: \"H400\"-> id = \"H400\")\n\n*For the old version (without smearing, distance preconditioning and theta) set legacy=true.\n\nExamples:\n\nread_mesons(path)\nread_mesons(path, \"G5\")\nread_mesons(path, nothing, \"G5\")\nread_mesons(path, \"G5\", \"G5\")\nread_mesons(path, \"G5\", \"G5\", id=\"H100\")\nread_mesons(path, \"G5_d2\", \"G5_d2\", legacy=true)\n\n\n\n\n\n","category":"function"},{"location":"reader.html#juobs.read_ms","page":"Reader","title":"juobs.read_ms","text":"read_ms(path::String; id::Union{String, Nothing}=nothing, dtr::Int64=1, obs::String=\"Y\")\n\nReads openQCD ms dat files at a given path. This method return YData: \n\nt(t): flow time values\nobs(icfg, x0, t): the time-slice sums of the densities of the observable (Wsl, Ysl or Qsl)\nvtr: vector that contains trajectory number\nid: ensmble id\n\ndtr = dtr_cnfg / dtr_ms, where dtr_cnfg is the number of trajectories computed before saving the configuration. dtr_ms is the same but applied to the ms.dat file.\n\nExamples:\n\nY = read_ms(path)\n\n\n\n\n\n","category":"function"},{"location":"reader.html#juobs.read_ms1","page":"Reader","title":"juobs.read_ms1","text":"read_ms1(path::String; v::String=\"1.2\")\n\nReads openQCD ms1 dat files at a given path. This method returns a matrix W[irw, icfg] that contains the reweighting factors, where irw is the rwf index and icfg the configuration number. The function is compatible with the output files of openQCD v=1.2, 1.4 and 1.6. Version can be specified as argument.\n\nExamples:\n\nread_ms1(path)\nread_ms1(path, v=\"1.4\")\nread_ms1(path, v=\"1.6\")\n\n\n\n\n\n","category":"function"},{"location":"reader.html#juobs.read_md","page":"Reader","title":"juobs.read_md","text":"read_md(path::String)\n\nReads openQCD  pbp.dat files at a given path. This method returns a matrix md[irw, icfg] that contains the derivatives dSdm, where mdirw=1 = dSdm_l and mdirw=2 = dSdm_s\n\nSeff = -tr(log(D+m))\n\ndSeff dm = -tr((D+m)^-1)\n\nExamples:\n\nmd = read_md(path)\n\n\n\n\n\n","category":"function"},{"location":"reader.html#juobs.truncate_data!","page":"Reader","title":"juobs.truncate_data!","text":"truncate_data!(data::YData, nc::Int64)\n\ntruncate_data!(data::Vector{YData}, nc::Vector{Int64})\n\ntruncate_data!(data::Vector{CData}, nc::Int64)\n\ntruncate_data!(data::Vector{Vector{CData}}, nc::Vector{Int64})\n\nTruncates the output of read_mesons and read_ms taking the first nc configurations.\n\nExamples:\n\n#Single replica\ndat = read_mesons(path, \"G5\", \"G5\")\nY = read_ms(path)\ntruncate_data!(dat, nc)\ntruncate_data!(Y, nc)\n\n#Two replicas\ndat = read_mesons([path1, path2], \"G5\", \"G5\")\nY = read_ms.([path1_ms, path2_ms])\ntruncate_data!(dat, [nc1, nc2])\ntruncate_data!(Y, [nc1, nc2])\n\n\n\n\n\n","category":"function"},{"location":"linalg.html#Linear-Algebra","page":"Linear Algebra","title":"Linear Algebra","text":"","category":"section"},{"location":"linalg.html","page":"Linear Algebra","title":"Linear Algebra","text":"uweigvals\nuweigvecs\nuweigen\nget_matrix\nenergies\ngetall_eigvals\ngetall_eigvecs","category":"page"},{"location":"linalg.html#juobs.uweigvals","page":"Linear Algebra","title":"juobs.uweigvals","text":"uweigvals(a::Matrix{uwreal}; iter = 30)\n\nuweigvals(a::Matrix{uwreal}, b::Matrix{uwreal};  iter = 30)\n\nThis function computes the eigenvalues of a matrix of uwreal objects. If a second matrix b is given as input, it returns the generalised eigenvalues instead. It takes as input:\n\na::Matrix{uwreal} : a matrix of uwreal\nb::Matrix{uwreal} : a matrix of uwreal, optional\niter=30: optional flag to set the iterations of the qr algorithm used to solve the eigenvalue problem\n\nIt returns:\n\nres = Vector{uwreal}: a vector where each elements is an eigenvalue \n\na = Matrix{uwreal}(nothing, n,n) ## n*n matrix of uwreal with nothing entries\nb = Matrix{uwreal}(nothing, n,n) ## n*n matrix of uwreal with nothing entries\n\nres = uweigvals(a)  ##eigenvalues\nres1 = uweigvals(a,b) ## generalised eigenvalues\n\n\n\n\n\n","category":"function"},{"location":"linalg.html#juobs.uweigvecs","page":"Linear Algebra","title":"juobs.uweigvecs","text":"uweigvecs(a::Matrix{uwreal}; iter = 30)\n\nuweigvecs(a::Matrix{uwreal}, b::Matrix{uwreal};  iter = 30)\n\nThis function computes the eigenvectors of a matrix of uwreal objects. If a second matrix b is given as input, it returns the generalised eigenvectors instead. It takes as input:\n\na::Matrix{uwreal} : a matrix of uwreal\nb::Matrix{uwreal} : a matrix of uwreal, optional\niter=30 : the number of iterations of the qr algorithm used to extract the eigenvalues \n\nIt returns:\n\nres = Matrix{uwreal}: a matrix where each column is an eigenvector \n\nExamples:\n\na = Matrix{uwreal}(nothing, n,n) ## n*n matrix of uwreal with nothing entries\nb = Matrix{uwreal}(nothing, n,n) ## n*n matrix of uwreal with nothing entries\n\nres = uweigvecs(a)  ##eigenvectors in column \nres1 = uweigvecs(a,b) ## generalised eigenvectors in column \n\n\n\n\n\n","category":"function"},{"location":"linalg.html#juobs.uweigen","page":"Linear Algebra","title":"juobs.uweigen","text":"uweigen(a::Matrix{uwreal}; iter = 30)\n\nuweigen(a::Matrix{uwreal}, b::Matrix{uwreal};  iter = 30)\n\nThis function computes the eigenvalues and the eigenvectors  of a matrix of uwreal objects. If a second matrix b is given as input, it returns the generalised eigenvalues and eigenvectors instead. It takes as input:\n\na::Matrix{uwreal} : a matrix of uwreal\nb::Matrix{uwreal} : a matrix of uwreal, optional\niter=30 : the number of iterations of the qr algorithm used to extract the eigenvalues \n\nIt returns:\n\nevals = Vector{uwreal}: a vector where each elements is an eigenvalue \nevecs  = Matrix{uwreal}: a matrix where the i-th column is the eigenvector of the i-th eigenvalue\n\nExamples:\n\na = Matrix{uwreal}(nothing, n,n) ## n*n matrix of uwreal with nothing entries\nb = Matrix{uwreal}(nothing, n,n) ## n*n matrix of uwreal with nothing entries\n\neval, evec = uweigen(a)   \neval1, evec1 = uweigvecs(a,b) \n\n\n\n\n\n","category":"function"},{"location":"linalg.html#juobs.get_matrix","page":"Linear Algebra","title":"juobs.get_matrix","text":"get_matrix(diag::Vector{Array}, upper::Vector{Array} )\n\nThis function allows the user to build an array of matrices, where each matrix is a  symmetric matrix of correlators at a given timeslice.   \n\nIt takes as input:\n\ndiag::Vector{Array}:  vector of correlators. Each correlator will constitute a diagonal element of the matrices A[i] where i runs over the timeslices, i.e.                A[i][1,1] = diag[1], .... A[i][n,n] = diag[n]                Given n=length(diag), the matrices will have dimension n*n \nupper::Vector{Array}:  vector of correlators liying on the upper diagonal position.               A[i][1,2] = upper[1], .. , A[i][1,n] = upper[n-1],               A[i][2,3] = upper[n], .. , A[i][n-1,n] = upper[n(n-1)/2]                Given n, length(upper)=n(n-1)/2\n\nThe method returns an array of symmetric matrices of dimension n for each timeslice  \n\nExamples:\n\n## load data \npp_data = read_mesons(path, \"G5\", \"G5\")\npa_data = read_mesons(path, \"G5\", \"G0G5\")\naa_data = read_mesons(path, \"G0G5\", \"G0G5\")\n\n## create Corr struct\ncorr_pp = corr_obs.(pp_data)\ncorr_pa = corr_obs.(pa_data)\ncorr_aa = corr_obs.(aa_data) # array of correlators for different \\mu_q combinations\n\n## set up matrices\ncorr_diag = [corr_pp[1], corr_aa[1]] \ncorr_upper = [corr_pa[1]]\n\nmatrices = [corr_diag, corr_upper]\n\nJulia> matrices[i]\n       pp[i]  ap[i]\n       pa[i]  aa[i]\n\n## where i runs over the timeslices\n\n\n\n\n\n","category":"function"},{"location":"linalg.html#juobs.energies","page":"Linear Algebra","title":"juobs.energies","text":"energies(evals::Vector{Array}; wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\nThis method computes the energy level from the eigenvalues according to:\n\nE_i(t) = log(λ(t)  λ(t+1))\n\nwhere i=1,..,n with n=length(evals[1]) and t=1,..,T  total time slices. It returns a vector array en where each entry en[i][t] contains the i-th states energy at time t \n\nExamples:\n\n## load data\npp_data = read_mesons(path, \"G5\", \"G5\")\npa_data = read_mesons(path, \"G5\", \"G0G5\")\naa_data = read_mesons(path, \"G0G5\", \"G0G5\")\n\n## create Corr struct\ncorr_pp = corr_obs.(pp_data)\ncorr_pa = corr_obs.(pa_data)\ncorr_aa = corr_obs.(aa_data) # array of correlators for different \\mu_q combinations\n\n## set up matrices \ncorr_diag = [corr_pp[1], corr_aa[1]] \ncorr_upper = [corr_pa[1]]\n\nmatrices = [corr_diag, corr_upper]\n\n## solve the GEVP\nevals = getall_eigvals(matrices, 5) #where t_0=5\nen = energies(evals)\n\nJulia> en[i] # i-th state energy at each timeslice\n\n\n\n\n\n","category":"function"},{"location":"linalg.html#juobs.getall_eigvals","page":"Linear Algebra","title":"juobs.getall_eigvals","text":"getall_eigvals(a::Vector{Matrix}, t0; iter=30 )\n\nThis function solves a GEVP problem, returning the eigenvalues, for a list of matrices, taking as generalised matrix the one  at index t0, i.e:\n\nC(t_i)v_i = λ_i C(t_0) v_i,   with   i=1:lenght(a)\n\nIt takes as input:\n\na::Vector{Matrix} : a vector of matrices\nt0::Int64 : idex value at which the fixed matrix is taken\niter=30 : the number of iterations of the qr algorithm used to extract the eigenvalues \n\nIt returns:\n\nres = Vector{Vector{uwreal}}\n\nwhere res[i] are the generalised eigenvalues of the i-th matrix of the input array. \n\nExamples:\n\n## load data\npp_data = read_mesons(path, \"G5\", \"G5\")\npa_data = read_mesons(path, \"G5\", \"G0G5\")\naa_data = read_mesons(path, \"G0G5\", \"G0G5\")\n\n## create Corr struct\ncorr_pp = corr_obs.(pp_data)\ncorr_pa = corr_obs.(pa_data)\ncorr_aa = corr_obs.(aa_data) # array of correlators for different \\mu_q combinations\n\n## set up matrices \ncorr_diag = [corr_pp[1], corr_aa[1]] \ncorr_upper = [corr_pa[1]]\n\nmatrices = [corr_diag, corr_upper]\n\n## solve the GEVP\n#evals = getall_eigvals(matrices, 5) #where t_0=5\n\n\nJulia>\n\n\n\n\n\n","category":"function"},{"location":"linalg.html#juobs.getall_eigvecs","page":"Linear Algebra","title":"juobs.getall_eigvecs","text":"getall_eigvecs(a::Vector{Matrix}, delta_t; iter=30 )\n\nThis function solves a GEVP problem, returning the eigenvectors, for a list of matrices.\n\nC(t_i)v_i = λ_i C(t_i-delta_t) v_i, with i=1:lenght(a)\n\nHere delta_t is the time shift within the two matrices of the problem, and is kept fixed. It takes as input:\n\na::Vector{Matrix} : a vector of matrices\ndelta_t::Int64 : the fixed time shift t-t_0\niter=30 : the number of iterations of the qr algorithm used to extract the eigenvalues \n\nIt returns:\n\nres = Vector{Matrix{uwreal}}\n\nwhere each res[i] is a matrix  with the eigenvectors as  columns Examples:\n\nmat_array = get_matrix(diag, upper_diag)\nevecs = getall_eigvecs(mat_array, 5)\n\n\n\n\n\n","category":"function"},{"location":"obs.html#Observables","page":"Observables","title":"Observables","text":"","category":"section"},{"location":"obs.html","page":"Observables","title":"Observables","text":"meff\nmpcac\ndec_const\ndec_const_pcvc\ncomp_t0","category":"page"},{"location":"obs.html#juobs.meff","page":"Observables","title":"juobs.meff","text":"meff(corr::Vector{uwreal}, plat::Vector{Int64}; pl::Bool=true, data::Bool=false, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)     \n\nmeff(corr::Corr, plat::Vector{Int64}; pl::Bool=true, data::Bool=false, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\nComputes effective mass for a given correlator corr at a given plateau plat. Correlator can be passed as an Corr struct or Vector{uwreal}.\n\nThe flags pl and data allow to show the plots and return data as an extra result.\n\ndata = read_mesons(path, \"G5\", \"G5\")\ncorr_pp = corr_obs.(data)\nm = meff(corr_pp[1], [50, 60], pl=false)\n\n\n\n\n\n","category":"function"},{"location":"obs.html#juobs.mpcac","page":"Observables","title":"juobs.mpcac","text":"mpcac(a0p::Vector{uwreal}, pp::Vector{uwreal}, plat::Vector{Int64}; ca::Float64=0.0, pl::Bool=true, data::Bool=false, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\nmpcac(a0p::Corr, pp::Corr, plat::Vector{Int64}; ca::Float64=0.0, pl::Bool=true, data::Bool=false, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\nComputes the bare PCAC mass for a given correlator a0p and pp at a given plateau plat. Correlator can be passed as an Corr struct or Vector{uwreal}.\n\nThe flags pl and data allow to show the plots and return data as an extra result. The ca variable allows to compute mpcac using the improved axial current.\n\ndata_pp = read_mesons(path, \"G5\", \"G5\")\ndata_a0p = read_mesons(path, \"G5\", \"G0G5\")\ncorr_pp = corr_obs.(data_pp)\ncorr_a0p = corr_obs.(data_a0p)\nm12 = mpcac(corr_a0p, corr_pp, [50, 60], pl=false)\n\np0 = 9.2056\np1 = -13.9847\ng2 = 1.73410\nca = -0.006033 * g2 *( 1 + exp(p0 + p1/g2))\n\nm12 = mpcac(corr_a0p, corr_pp, [50, 60], pl=false, ca=ca)\n\n\n\n\n\n","category":"function"},{"location":"obs.html#juobs.dec_const","page":"Observables","title":"juobs.dec_const","text":"dec_const(a0p::Vector{uwreal}, pp::Vector{uwreal}, plat::Vector{Int64}, m::uwreal, y0::Int64; ca::Float64=0.0, pl::Bool=true, data::Bool=false, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\ndec_const(a0p::Corr, pp::Corr, plat::Vector{Int64}, m::uwreal; ca::Float64=0.0, pl::Bool=true, data::Bool=false, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\ndec_const(a0pL::Vector{uwreal}, a0pR::Vector{uwreal}, ppL::Vector{uwreal}, ppR::Vector{uwreal}, plat::Vector{Int64}, m::uwreal, y0::Int64; ca::Float64=0.0, pl::Bool=true, data::Bool=false, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\ndec_const(a0pL::Corr, a0pR::Corr, ppL::Corr, ppR::Corr, plat::Vector{Int64}, m::uwreal; ca::Float64=0.0, pl::Bool=true, data::Bool=false, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\nComputes the bare decay constant using A_0P and PP correlators . The decay constant is computed in the plateau plat. Correlator can be passed as an Corr struct or Vector{uwreal}. If it is passed as a uwreal vector, effective mass m and source position y0 must be specified.\n\nThe flags pl and data allow to show the plots and return data as an extra result. The ca variable allows to compute dec_const using the improved axial current.\n\nThe method assumes that the source is close to the boundary. It takes the following ratio to cancel boundary effects. R = fracf_A(x_0 y_0)sqrtf_P(T-y_0 y_0) * e^m (x_0 - T2)\n\nIf left and right correlators are included in the input. The result is computed with the following ratio R = sqrtf_A(x_0 y_0) * f_A(x_0 T - 1 - y_0)  f_P(T - 1 - y_0 y_0)\n\ndata_pp = read_mesons(path, \"G5\", \"G5\", legacy=true)\ndata_a0p = read_mesons(path, \"G5\", \"G0G5\", legacy=true)\n\ncorr_pp = corr_obs.(data_pp, L=32)\ncorr_a0p = corr_obs.(data_a0p, L=32)\n\ncorr_a0pL, corr_a0pR = [corr_a0p[1], corr_a0p[2]]\ncorr_ppL, corr_ppR = [corr_pp[1], corr_pp[2]]\n\nm = meff(corr_pp[1], [50, 60], pl=false)\n\nbeta = 3.46\np0 = 9.2056\np1 = -13.9847\ng2 = 6 / beta\nca = -0.006033 * g2 *( 1 + exp(p0 + p1/g2))\n\nf = dec_const(corr_a0p[1], corr_pp[1], [50, 60], m, pl=true, ca=ca)\n\nf_ratio = dec_const(corr_a0pL, corr_a0pR, corr_ppL, corr_ppR, [50, 60], m, pl=true, ca=ca)\n\n\n\n\n\n","category":"function"},{"location":"obs.html#juobs.dec_const_pcvc","page":"Observables","title":"juobs.dec_const_pcvc","text":"dec_const_pcvc(corr::Vector{uwreal}, plat::Vector{Int64}, m::uwreal, mu::Vector{Float64}, y0::Int64 ; pl::Bool=true, data::Bool=false, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\ndec_const_pcvc(corr::Corr, plat::Vector{Int64}, m::uwreal; pl::Bool=true, data::Bool=false, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\ndec_const_pcvc(ppL::Vector{uwreal}, ppR::Vector{uwreal}, plat::Vector{Int64}, m::uwreal, mu::Vector{Float64}, y0::Int64 ; pl::Bool=true, data::Bool=false, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\ndec_const_pcvc(corrL::Corr, corrR::Corr, plat::Vector{Int64}, m::uwreal; pl::Bool=true, data::Bool=false, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\nComputes decay constant using the PCVC relation for twisted mass fermions. The decay constant is computed in the plateau plat. Correlator can be passed as an Corr struct or Vector{uwreal}. If it is passed as a uwreal vector, vector of twisted masses mu and source position y0 must be specified.\n\nThe flags pl and data allow to show the plots and return data as an extra result.\n\nThe method extract the matrix element assuming that the source is in the bulk. ** **If left and right correlators are included in the input. The result is computed with a ratio that cancels boundary effects: R = sqrtf_P(x_0 y_0) * f_P(x_0 T - 1 - y_0)  f_P(T - 1 - y_0 y_0)\n\ndata = read_mesons(path, \"G5\", \"G5\")\ncorr_pp = corr_obs.(data, L=32)\nm = meff(corr_pp[1], [50, 60], pl=false)\nf = dec_const_pcvc(corr_pp[1], [50, 60], m, pl=false)\n\n#left and right correlators\nf_ratio = dec_const_pcvc(ppL, ppR, [50, 60], m)\n\n\n\n\n\n","category":"function"},{"location":"obs.html#juobs.comp_t0","page":"Observables","title":"juobs.comp_t0","text":"comp_t0(Y::YData, plat::Vector{Int64}; L::Int64, pl::Bool=false, rw::Union{Matrix{Float64}, Nothing}=nothing, npol::Int64=2, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing, info::Bool=false)\n\ncomp_t0(Y::Vector{YData}, plat::Vector{Int64}; L::Int64, pl::Bool=false, rw::Union{Vector{Matrix{Float64}}, Nothing}=nothing, npol::Int64=2, wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing, info::Bool=false)\n\nComputes t0 using the energy density of the action Ysl(Yang-Mills action). t0 is computed in the plateau plat. A polynomial interpolation in t is performed to find t0, where npol is the degree of the polynomial (linear fit by default)\n\nThe flag pl allows to show the plot. \n\nThe flag info provides extra output that contains information about the primary observables. The function returns the primary observables WY and W (it returns the observable <Y> if rw=nothing)\n\n#Single replica\nY = read_ms(path)\nrw = read_ms(path_rw)\n\nt0, Yobs = comp_t0(Y, [38, 58], L=32, info=true)\nt0_r, WYobs, Wobs = comp_t0(Y, [38, 58], L=32, rw=rw, info=true)\n\n#Two replicas\nY1 = read_ms(path1)\nY2 = read_ms(path2)\nrw1 = read_ms(path_rw1)\nrw2 = read_ms(path_rw2)\n\nt0 = comp_t0([Y1, Y2], [38, 58], L=32, pl=true)\nt0_r = comp_t0(Y, [38, 58], L=32, rw=[rw1, rw2], pl=true)\n\n\n\n\n\n\n","category":"function"},{"location":"index.html#DOCUMENTATION","page":"Home","title":"DOCUMENTATION","text":"","category":"section"},{"location":"index.html#Contents","page":"Home","title":"Contents","text":"","category":"section"},{"location":"index.html","page":"Home","title":"Home","text":"Pages = [\"reader.md\", \"tools.md\", \"obs.md\", \"linalg.md\"]\nDepth = 3","category":"page"},{"location":"tools.html#Tools","page":"Tools","title":"Tools","text":"","category":"section"},{"location":"tools.html","page":"Tools","title":"Tools","text":"corr_obs\ncorr_sym\nmd_sea\nmd_val\nlin_fit\nfit_routine\nbayesian_av","category":"page"},{"location":"tools.html#juobs.corr_obs","page":"Tools","title":"juobs.corr_obs","text":"corr_obs(cdata::CData; real::Bool=true, rw::Union{Array{Float64, 2}, Nothing}=nothing, L::Int64=1, info::Bool=false)\n\ncorr_obs(cdata::Array{CData, 1}; real::Bool=true, rw::Union{Array{Array{Float64, 2}, 1}, Nothing}=nothing, L::Int64=1, info::Bool=false)\n\nCreates a Corr struct with the given CData struct cdata (read_mesons) for a single replica. An array of CData can be passed as argument for multiple replicas.\n\nThe flag real select the real or imaginary part of the correlator. If rw is specified, the method applies reweighting. rw is passed as a matrix of Float64 (read_ms1) The correlator can be normalized with the volume factor if L is fixed.\n\nThe flag info provides extra output that contains information about the primary observables. The function returns the primary observables WO and W (it returns the observable <O> if rw=nothing)\n\n#Single replica\ndata = read_mesons(path, \"G5\", \"G5\")\nrw = read_ms1(path_rw)\ncorr_pp = corr_obs.(data)\ncorr_pp_r = corr_obs.(data, rw=rw)\n\n#Single replica + Info\ndata = read_mesons(path, \"G5\", \"G5\")\nrw = read_ms1(path_rw)\ncorr_pp, O = corr_obs(data[1], info=true)\ncorr_pp_r, WO, W = corr_obs(data[1], rw=rw, info=true)\n\n#Two replicas\ndata = read_mesons([path_r1, path_r2], \"G5\", \"G5\")\nrw1 = read_ms1(path_rw1)\nrw2 = read_ms1(path_rw2)\n\ncorr_pp = corr_obs.(data)\ncorr_pp_r = corr_obs.(data, rw=[rw1, rw2])\n\n\n\n\n\n","category":"function"},{"location":"tools.html#juobs.corr_sym","page":"Tools","title":"juobs.corr_sym","text":"corr_sym(corrL::Corr, corrR::Corr, parity::Int64=1)\n\nComputes the symmetrized correlator using the left correlador corrL and the right correlator corrR. The source position of corrR must be T - 1 - y0, where y0 is the source position of corrL. \n\npp_sym = corr_sym(ppL, ppR, +1)\na0p_sym = corr_sym(a0pL, a0pR, -1)\n\n\n\n\n\n","category":"function"},{"location":"tools.html#juobs.md_sea","page":"Tools","title":"juobs.md_sea","text":"md_sea(a::uwreal, md::Vector{Matrix{Float64}}, ow::uwreal, w::Union{uwreal, Nothing}=nothing, ws::ADerrors.wspace=ADerrors.wsg)\n\nmd_sea(a::uwreal, md::Vector{Matrix{Float64}}, ow::Array{uwreal}, w::Union{uwreal, Nothing}=nothing, ws::ADerrors.wspace=ADerrors.wsg)\n\nComputes the derivative of an observable A with respect to the sea quark masses.\n\nfracd Adm(sea) = sum_i fracpartial Apartial O_i  fracd O_id m(sea)\n\nfracd O_idm(sea) = O_i fracpartial Spartial m - O_i fracpartial Spartial m\n\nwhere O_i are primary observables. The function returns  fracpartial Apartial O_i  fracd O_id m(sea), where the primary observable O_i is specified as an input argument.\n\now is a primary observable or a vector of primary observables that contains OW (O if reweighting is not applied) and  w is a primary obserable that contains the reweighting factors W (w=nothing if reweighting is not applied).\n\nmd is a vector that contains the derivative of the action S with respect to the sea quark masses for each replica. md[irep][irw, icfg]\n\nmd_sea returns a tuple of uwreal observables (dAdm_l dAdm_s)_sea,  where m_l and m_s are the light and strange quark masses.\n\n#Single replica\ndata = read_mesons(path, \"G5\", \"G5\")\nmd = read_md(path_md)\nrw = read_ms1(path_rw)\n\ncorr_pp, wpp, w = corr_obs.(data[1], rw=rw, info=true)\nm = meff(corr_pp[1], plat)\nm_mdl, m_mds = md_sea(m, [md], wpp, w, ADerrors.wsg)\nm_shifted = m + 2 * dml * m_mdl + dms * m_mds\n\n#Two replicas\ndata = read_mesons([path_r1, path_r2], \"G5\", \"G5\")\nmd1 = read_md(path_md1)\nmd2 = read_md(path_md2)\n\ncorr_pp, pp = corr_obs(data[1], info=true)\nm = meff(corr_pp[1], plat)\nm_mdl, m_mds = md_sea(m, [md1, md2], pp, ADerrors.wsg)\nm_shifted = m + 2 * dml * m_mdl + dms * m_mds\n\n\n\n\n\n","category":"function"},{"location":"tools.html#juobs.md_val","page":"Tools","title":"juobs.md_val","text":"md_val(a::uwreal, obs::Corr, derm::Vector{Corr})\n\nComputes the derivative of an observable A with respect to the valence quark masses.\n\nfracd Adm(val) = sum_i fracpartial Apartial O_i  fracd O_id m(val)\n\nfracd O_idm(val) = fracpartial O_ipartial m(val)\n\nwhere O_i are primary observables \n\nmd is a vector that contains the derivative of the action S with respect to the sea quark masses for each replica. md[irep][irw, icfg]\n\nmd_val returns a tuple of uwreal observables (dAdm_1 dAdm_2)_val,  where m_1 and m_2 are the correlator masses.\n\ndata = read_mesons(path, \"G5\", \"G5\", legacy=true)\ndata_d1 = read_mesons(path, \"G5_d1\", \"G5_d1\", legacy=true)\ndata_d2 = read_mesons(path, \"G5_d2\", \"G5_d2\", legacy=true)\n\nrw = read_ms1(path_rw)\n\ncorr_pp = corr_obs.(data, rw=rw)\ncorr_pp_d1 = corr_obs.(data_d1, rw=rw)\ncorr_pp_d2 = corr_obs.(data_d2, rw=rw)\nderm = [[corr_pp_d1[k], corr_pp_d2[k]] for k = 1:length(pp_d1)]\n\nm = meff(corr_pp[1], plat)\nm_md1, m_md2 = md_val(m, corr_pp[1], derm[1])\nm_shifted = m + dm1 * m_md1 + dm2 * m_md2\n\n\n\n\n\n","category":"function"},{"location":"tools.html#juobs.lin_fit","page":"Tools","title":"juobs.lin_fit","text":"lin_fit(x::Vector{<:Real}, y::Vector{uwreal})\n\nComputes a linear fit of uwreal data points y. This method return uwreal fit parameters and chisqexpected.\n\nfitp, csqexp = lin_fit(phi2, m2)\nm2_phys = fitp[1] + fitp[2] * phi2_phys\n\n\n\n\n\n","category":"function"},{"location":"tools.html#juobs.fit_routine","page":"Tools","title":"juobs.fit_routine","text":"fit_routine(model::Function, xdata::Array{<:Real}, ydata::Array{uwreal}, param::Int64=3; wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\nfit_routine(model::Function, xdata::Array{uwreal}, ydata::Array{uwreal}, param::Int64=3; wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing, covar::Bool=false)\n\nGiven a model function with a number param of parameters and an array of uwreal, this function fit ydata with the given model and print fit information The method return an array upar with the best fit parameters with their errors. The flag wpm is an optional array of Float64 of lenght 4. The first three paramenters specify the criteria to determine the summation windows:\n\nvp[1]: The autocorrelation function is summed up to t = round(vp1).\nvp[2]: The sumation window is determined using U. Wolff poposal with S_tau = wpm2\nvp[3]: The autocorrelation function Gamma(t) is summed up a point where its error deltaGamma(t) is a factor vp[3] times larger than the signal.\n\nAn additional fourth parameter vp[4], tells ADerrors to add a tail to the error with tau_exp = wpm4. Negative values of wpm[1:4] are ignored and only one component of wpm[1:3] needs to be positive. If the flag covaris set to true, fit_routine takes into account covariances between x and y for each data point.\n\n@. model(x,p) = p[1] + p[2] * exp(-(p[3]-p[1])*x)\n@. model2(x,p) = p[1] + p[2] * x[:, 1] + (p[3] + p[4] * x[:, 1]) * x[:, 2]\nfit_routine(model, xdata, ydata, param=3)\nfit_routine(model, xdata, ydata, param=3, covar=true)\n\n\n\n\n\n","category":"function"},{"location":"tools.html#juobs.bayesian_av","page":"Tools","title":"juobs.bayesian_av","text":"bayesian_av(fun::Function, y::Array{uwreal}, tmin_array::Array{Int64}, tmax_array::Array{Int64}, k::Int64, pl::Bool, data::Bool; wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\nbayesian_av(fun1::Function, fun2::Function, y::Array{uwreal}, tmin_array::Array{Int64}, tmax_array::Array{Int64}, k1::Int64, k2::Int64, pl::Bool, data::Bool; wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\nbayesian_av(fun::Array{Function}, y::Array{uwreal}, tmin_array::Array{Int64}, tmax_array::Array{Int64}, k::Array{Int64}, pl::Bool, data::Bool; wpm::Union{Dict{Int64,Vector{Float64}},Dict{String,Vector{Float64}}, Nothing}=nothing)\n\nComputes bayesian average of data. For a given fit function, it explores choices of fit intervals, assigning each of them a weight. The function saves the first fit parameter of your function, and then it does the weighted average of it and assigns a systematic. See https://arxiv.org/abs/2008.01069 \n\nThe function takes as input the fit intervals to explore. \n\ntmin_array is an array of integers with the lower bounds on the fit intervals to explore, ***ordered from lower to higher***.\n\ntmax_array is an array of integers with the upper bounds on the fit intervals to explore, ***ordered from lower to higher***.\n\nk is the number of parameters of the fit function to use.\n\nYou can also use as input two fit functions, and two values of k, one for each function. Then, for each fit interval choice, the function explores the two fit functions. This means that for each fit interval choice you get two results: one for the first fit funcction, and another for the second. You can also use a vector of functions and a vector of k (numer of parameters of each funtion) to apply the bayesian averaging method to multiple functions.\n\nThe method returns two objects: first, the weighted average as an uwreal object, with mean value and statistichal error. The second object returned is the systematic error coming from the fit interval variation. If data is true, then returns 4 objects: weighted average, systematic error, a vector with the results of the fit for each fit interval choice, and a vector with the weights associated to each fit.\n\n@.fun(x,p) = p[1] * x ^0\nk = 1\ntmin_array = [10,11,12,13,14,15]\ntmax_array = [80,81,82,83,84,85]\n(average, systematics, data, weights) = bayesian_av(fun,x,tmin_array,tmax_array,k,pl=true,data=true)\n\n@.fun1(x,p) = p[1] * x ^0\n@.fun2(x,p) = p[1] + p[2] * exp( - p[3] * (x))\nk1 = 1\nk2 = 3\ntmin_array = [10,11,12,13,14,15]\ntmax_array = [80,81,82,83,84,85]\n(average, systematics) = bayesian_av(fun1,fun2,x,tmin_array,tmax_array,k1,k2)\n\n@.fun1(x,p) = p[1] * x ^0\n@.fun2(x,p) = p[1] + p[2] * exp( - p[3] * (x))\nk1 = 1\nk2 = 3\ntmin_array = [10,11,12,13,14,15]\ntmax_array = [80,81,82,83,84,85]\n(average, systematics) = bayesian_av([fun1,fun2],x,tmin_array,tmax_array,[k1,k2])\n\n\n\n\n\n","category":"function"}]
}
