module juobs
using ADerrors, PyPlot, LaTeXStrings, LinearAlgebra, LsqFit, Optim, ForwardDiff
using Base: Float64
import Statistics: mean


include("juobs_types.jl")
include("juobs_linalg.jl")
include("juobs_reader.jl")
include("juobs_gammaMethod.jl")
include("juobs_tools.jl")
include("juobs_plots.jl")
include("juobs_obs.jl")
include("../constants/juobs_const.jl")
include("../constants/path_csv.jl")
#include("../constants/juobs_uwreal_const.jl")

export EnsInfo
export ens_db, db, db_c, flag_s, sym_bool, ensemble_inv
export read_mesons, read_mesons_correction, read_mesons_multichunks, read_mesons_correction_multichunks, read_ens_tm, read_ens_tm_sym, read_ens_TSM, read_ens_wil, read_ens_csv, get_corr_tm, get_corr_TSM, get_corr_TSM_multichunks, get_corr_wil, read_ms1, read_ms, read_md, get_YM, get_YM_dYM, truncate_data!, concat_data!
export get_matrix, energies, uwdot, uweigvals, uweigvecs, uweigen, invert, getall_eigvals, getall_eigvecs, hess_reduce, uwcholesky, transpose, tridiag_reduction, make_positive_def, invert_covar_matrix
export corr_obs, corr_obs_TSM, corr_sym, corr_sym_E250, corr_sym_D450, md_sea, md_val, plat_av, lin_fit, x_lin_fit, y_lin_fit, fit_routine, global_fit_routine, bayesian_av, pvalue
export plot_data,plot_func, pvalue, fve, model_av, fit_alg
export meff, mpcac, dec_const, dec_const_w, dec_const_w, dec_const_pcvc, comp_t0, get_m, get_m_pbc, get_mpcac, get_f_wil, get_f_wil_pbc, get_f_tm, get_f_tm_pbc, get_w0t0_plat
export GammaMethod
  
end # module
