using Revise, juobs, ADerrors

true_model(x) = 0.5 + 0.02*x +0.001*x^2

xdata = collect(0.0:0.1:1)
ydata = let
    yaux = true_model.(xdata)
    [uwreal(randn(1000)*0.0003.+y,"fit_test") for y in yaux]
end
uwerr.(ydata)

@.model(x,p) = p[1] + p[2]*x + p[3]*x^2

println("true model: 0.5 + 0.02x + 0.0001x^2")
println("fit model:  p[1]+ p[2]x + p[3]x^2 ")
fit = fit_routine(model,xdata,ydata,3,logfile=stdout,corr=false);

xdata_s = [uwreal(randn(1000)*0.0003.+x,"xdata") for x in xdata]
fit2 = fit_routine(model,xdata_s,ydata,3,logfile=stdout,corr=false)

@.model2(x,p) = p[1] + (p[2] + p[3]*x)^2

Cy = [y.err^2 for y in ydata]
Cy = [i==j ? Cy[i] : 0 for i in eachindex(ydata), j in eachindex(ydata)]
W = [C==0 ?  0 : 1/C  for C in Cy ]
fit3 = fit_routine([model,model2],[xdata,xdata],[ydata,ydata],[3,3],corr=false,logfile=stdout, W=[W,W],C=[Cy,Cy])

true
