
##############UTILITY NAMES##############
  #=  STARTING AT 0
    noise_name=['Z2', 'GAUSS', 'U1', 'Z4']
    gamma_name = ['G0', 'G1', 'G2', 'G3',
'invalid', 'G5', '1', 'G0G1', 'G0G2', 'G0G3',
'G0G5', 'G1G2', 'G1G3', 'G1G5', 'G2G3', 'G2G5', 'G3G5']

    # quark and gauge Smearing types
    qs_name=['Local', 'Wuppertal', '3D Gradient Flow', 'Gradient Flow']
    gs_name=['Local', 'APE', '3D Wilson Flow', 'Quark 3D Gradient Flow', 'Quark Gradient Flow']
=#
const noise_name=["Z2", "GAUSS", "U1", "Z4"]
const gamma_name = ["G0", "G1", "G2", "G3",
"invalid", "G5", "1", "G0G1", "G0G2", "G0G3",
"G0G5", "G1G2", "G1G3", "G1G5", "G2G3", "G2G5", "G3G5", 
"G0_d1", "G1_d1", "G2_d1", "G3_d1",
"invalid", "G5_d1", "1_d1", "G0G1_d1", "G0G2_d1", "G0G3_d1",
"G0G5_d1", "G1G2_d1", "G1G3_d1", "G1G5_d1", "G2G3_d1", "G2G5_d1", "G3G5_d1",
"G0_d2", "G1_d2", "G2_d2", "G3_d2",
"invalid", "G5_d2", "1_d2", "G0G1_d2", "G0G2_d2", "G0G3_d2",
"G0G5_d2", "G1G2_d2", "G1G3_d2", "G1G5_d2", "G2G3_d2", "G2G5_d2", "G3G5_d2"]
const qs_name=["Local", "Wuppertal", "3D Gradient Flow", "Gradient Flow"]
const gs_name=["Local", "APE", "3D Wilson Flow", "Quark 3D Gradient Flow", "Quark Gradient Flow"]

mutable struct GHeader
    ncorr::Int32
    nnoise::Int32
    tvals::Int32
    noisetype::Int32

    hsize::Int32 #headersize
    GHeader(a, b, c, d) = new(a, b, c, d, 4*4)
    function GHeader(x::Vector{Int32})
        a = new(x[1], x[2], x[3], x[4], 4*4)
        return a
    end
end

mutable struct Sm
    type::Int32
    niter::Int32
    eps::Float64
    qg::Int32 #1->fermionic 2->gluonic
    Sm(t,q) = new(t, 0, 0.0, q)
    Sm(t, n, e, q) = new(t, n, e, q)
end

mutable struct CHeader
    k1::Float64
    k2::Float64
    mu1::Float64
    mu2::Float64
    dp1::Float64
    dp2::Float64
    theta1::Vector{Float64}
    theta2::Vector{Float64}
    q1::Sm
    q2::Sm
    g1::Sm
    g2::Sm
    type1::Int32
    type2::Int32
    x0::Int32
    is_real::Int32

    hsize::Int32 #headersize
    dsize::Int32 #datasize / (nnoise * T * ncfg)

    function CHeader(aux_f::Vector{Float64}, aux_i::Vector{Int32}, theta::Vector{Float64}, sm_par::Vector{Sm})
        a = new()
        a.k1 = aux_f[1]
        a.k2 = aux_f[2]
        a.mu1 = aux_f[3]
        a.mu2 = aux_f[4]
        a.dp1 = aux_f[5]
        a.dp2 = aux_f[6]
        a.type1 = aux_i[1]
        a.type2 = aux_i[2]
        a.x0 = aux_i[3]
        a.is_real = aux_i[4]

        a.theta1 = theta[1:3]
        a.theta2 = theta[4:6]
        a.q1 = sm_par[1]
        a.q2 = sm_par[2]
        a.g1 = sm_par[3]
        a.g2 = sm_par[4]
        a.hsize = 8*12 + 4*8 #without smearing parameters niter, neps
        if a.q1.type != 0
            a.hsize += 8+4
        end
        if a.q2.type != 0
            a.hsize += 8+4
        end
        if a.g1.type != 0 && a.g1.type != 3 && a.g1.type != 4
            a.hsize += 8+4
        end
        if a.g2.type != 0 && a.g2.type != 3 && a.g2.type != 4
            a.hsize += 8+4
        end
        a.dsize = 16 - 8* a.is_real 
        
        return a
    end
    function CHeader(aux_f::Vector{Float64}, aux_i::Vector{Int32})
        a = new()
        a.k1 = aux_f[1]
        a.k2 = aux_f[2]
        a.mu1 = aux_f[3]
        a.mu2 = aux_f[4]
        a.dp1 = 0.0
        a.dp2 = 0.0
        a.type1 = aux_i[1]
        a.type2 = aux_i[2]
        a.x0 = aux_i[3]
        a.is_real = aux_i[4]

        a.theta1 = zeros(3)
        a.theta2 = zeros(3)
        a.q1 = Sm(0, 1)
        a.q2 = Sm(0, 1)
        a.g1 = Sm(0, 2)
        a.g2 = Sm(0, 2)
        a.hsize = 8*4 + 4*4
        a.dsize = 16 - 8* a.is_real 

        return a
    end
end
function Base.:(==)(a::CHeader, b::CHeader)
    for s in [:k1, :k2, :mu1, :mu2, :dp1, :dp2, :type1, :type2, :x0, :is_real, :theta1, :theta2]
        if getfield(a, s) != getfield(b, s)
            return false
        end
    end
    return true
end
#Base.:(!=)(a::CHeader, b::CHeader) = !(a == b)

mutable struct CData
    header::CHeader
    vcfg::Array{Int32}
    re_data::Array{Float64}
    im_data::Array{Float64}
    id::String
    CData(a, b, c, d, e) = new(a, b, c, d, e)

end
Base.copy(a::CData) = CData(a.header, a.vcfg, a.re_data, a.im_data, a.id)

mutable struct Corr
    obs::Vector{uwreal}
    kappa::Vector{Float64}
    mu::Vector{Float64}
    gamma::Vector{String}
    y0::Int64
    theta1::Vector{Float64}
    theta2::Vector{Float64}
    function Corr(a::Vector{uwreal}, b::CData)
        h = getfield(b, :header)
        kappa = [h.k1, h.k2]
        mu = [h.mu1, h.mu2]
        gamma = [gamma_name[h.type1+1], gamma_name[h.type2+1]]
        y0 = Int64(h.x0)
        theta1 = h.theta1
        theta2 = h.theta2
        return new(a, kappa, mu, gamma, y0, theta1, theta2)
    end 
    function Corr(a::Vector{uwreal}, b::Vector{CData})
        sym = [:k1, :k2, :mu1, :mu2, :type1, :type2, :x0]
        h = getfield.(b, :header)
        for s in sym
            if !all(getfield.(h, s) .== getfield(h[1], s))
                error("Corr: Parameter mismatch")
            end
        end
        kappa = [h[1].k1, h[1].k2]
        mu = [h[1].mu1, h[1].mu2]
        gamma = [gamma_name[h[1].type1+1], gamma_name[h[1].type2+1]]
        y0 = Int64(h[1].x0)
        theta1 = h[1].theta1
        theta2 = h[1].theta2
        return new(a, kappa, mu, gamma, y0, theta1, theta2)
    end 
    Corr(o::Vector{uwreal}, k::Vector{Float64}, m::Vector{Float64}, g::Vector{String}, y::Int64, th1::Vector{Float64}, th2::Vector{Float64} ) = new(o, k, m, g, y, th1, th2)
end

mutable struct YData
    vtr::Vector{Int32}
    t::Vector{Float64}
    obs::Array{Float64, 3}
    id::String
    YData(a, b, c, d) = new(a, b, c, d)
end

@doc raw"""

    EnsInfo(ens_id::String, info::Vector{Any})

Stores information about the ensamble `ens_id`

`info::Vector{Any}` is a vector with 6 components that are:
  -`L::Int64` = number of site in the spatial direction
  -`T::Int64` = number of site in the temporal direction
  -`beta::Float64`
  -`ca::Float64` = c_A improvement parameters of the axial current
  -`dtr::Int64` = ??
  -`vrw::Union{String,Vector{string}}` = version of the reweighting factor. 
  -`cnfg::Vector{Int64}`= number of configuration per replica
The fields in `EnsInfo` are the same as before, plus the `id::String` of the ensemble

Examples:
```@example    
id = "H101"
ens = EnsInfo(id, ens_db[id])
```
"""
mutable struct EnsInfo
    id::String
    L::Int64
    T::Int64
    beta::Float64
    ca::Float64
    dtr::Int64
    vrw::Union{String, Vector{String}}
    cnfg::Vector{Int64}
    function EnsInfo(ens_id::String, info::Vector{Any})
        id = ens_id
        L = info[1]
        T = info[2]
        beta = info[3]
        dtr = info[4]
        vrw = info[5]
	    cnfg = info[6]

        p0 = 9.2056
        p1 = -13.9847
        g2 = 6 ./ beta 
        ca = - 0.006033 .* g2 .*( 1 .+exp.(p0 .+ p1./g2)) 
        return new(id, L, T, beta, ca, dtr, vrw, cnfg)
    end
    function EnsInfo(ens_id::String)
      if haskey(ens_db,ens_id)
        return EnsInfo(ens_id,ens_db[ens_id])
      else
        error("$ens_id is not in database")
      end
    end
end

function Base.show(io::IO, a::GHeader)
    print(io, "ncorr = ", a.ncorr, "\t")
    print(io, "nnoise = ", a.nnoise, "\t")
    print(io, "tvals = ", a.tvals, "\t")
    print(io, "noisetype = ", noise_name[a.noisetype + 1], "\t")
    print(io, "\n")

end

function Base.show(io::IO, a::CHeader)

    fnames = fieldnames(CHeader)
    for k in fnames
        f = getfield(a, k)
        if k != :type1 && k!= :type2
            print(io, "$k = $f\t")
        else
            print(io, "$k = ", gamma_name[f + 1], "\t")   
        end
    end
    print(io, "\n")
end

function Base.show(io::IO, a::Sm)
    print(io, "\n")
    if a.qg == 1
        print(io, "type = ", qs_name[a.type+1], "\t")
    elseif a.qg == 2
        print(io, "type = ", gs_name[a.type+1], "\t")
    end
    print(io, "niter = ", a.niter, "\t")
    print(io, "eps = ", a.eps, "\t")
    print(io, "\n")
end

function Base.show(io::IO, a::CData)
    print(io, a.header)
end

function Base.show(io::IO, a::Corr)
    fnames = fieldnames(Corr)
    for k in fnames
        f = getfield(a, k)
        if k != :obs
            print(io, "$k = $f\t")
        end
    end
end
